import 'package:viserpay/data/model/global/meassage_model.dart';
import 'package:viserpay/data/model/savings/savings_history_response_model.dart';

class InstallmentResponseModel {
  final String? remark;
  final String? status;
  final Message? message;
  final DpsHistoryData? data;

  InstallmentResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory InstallmentResponseModel.fromJson(Map<String, dynamic> json) => InstallmentResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : DpsHistoryData.fromJson(json['data']),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data,
      };
}

// class Data {
//   final DpsHistoryData? accounts;
//   final String? organizationImagePath;

//   Data({
//     this.accounts,
//     this.organizationImagePath,
//   });

//   factory Data.fromJson(Map<String, dynamic> json) => Data(
//         accounts: json["accounts"] == null ? null : DpsHistoryData.fromJson(json["accounts"]),
//         organizationImagePath: json['organization_image_path'],
//       );
// }
